<?php
      
if (!defined('TL_ROOT')) die('You can not access this file directly!');

/**
 * TYPOlight webCMS
 *
 * The TYPOlight webCMS is an accessible web content management system that 
 * specializes in accessibility and generates W3C-compliant HTML code. It 
 * provides a wide range of functionality to develop professional websites 
 * including a built-in search engine, form generator, file and user manager, 
 * CSS engine, multi-language support and many more. For more information and 
 * additional TYPOlight applications like the TYPOlight MVC Framework please 
 * visit the project website http://www.typolight.org.
 *
 */


/**
 * @filesource: http://www.mediensozialismus.de
 * @license: GPL
 */

class ModuleTopClick extends Module
{

	/**
	 * Template file
	 * @var string
	 */
	protected $strTemplate = 'mod_topclick';

	/**
	 * Get all records and add them to an array
	 */
	protected function compile()
	{
		$limit = null;
		$arrtopclick = array();

		// Pagination
				
		if ($this->perPage > 0)
		{
			$limit = $this->perPage;
						
			// Get total number of comments
			$objTotal = $this->Database->prepare("SELECT COUNT(*) AS count FROM tl_votesite")
									   ->execute($this->id, 1);
		}
		
		// Get all published comments
		$arrtopclick = array();
		$objtopclick = $this->Database->prepare("SELECT * FROM tl_votesite ORDER BY total_votes DESC");
		
		if ($limit)
		{
			$objtopclick->limit($limit);
		}

		$objtopclick = $objtopclick->execute($this->id, 1);

		if ($objtopclick->numRows)
		{
			$count = 0;
			$votecount = 1;
			$objTemplate = new FrontendTemplate($this->com_template);
			
		while ($objtopclick->next())
		{
		  $votezahl = $votecount;
      $votecount++;
			
      $arrtopclick[] = array
			(
			  'number' => $votezahl,
				'site' => $objtopclick->site,
				'src' => 'image.php?src=' . $objtopclick->image,
				'alt' => specialchars($objtopclick->site),
				'id' => $objtopclick->id,
				'total_votes' => $objtopclick->total_votes,
				'total_value' => $objtopclick->total_value,
				'used_ips' => $objtopclick->used_ips,
				'star' => $objtopclick->star,
				'name' => $objtopclick->name,
				'text' => $objtopclick->text,
			);
		}

		$this->Template->topclick = $arrtopclick; 
		}
	}
}

function rating_bar_topclick($id,$units='',$static='') { 

$rating_unitwidth     = 20;  

//set some variables
$ip = $_SERVER['REMOTE_ADDR'];
if (!$units) {$units = 10;}
if (!$static) {$static = FALSE;}

// get votes, values, ips for the current rating bar
$query=mysql_query("SELECT total_votes, total_value, used_ips FROM tl_votesite WHERE id='$id' ")or die(" Error: ".mysql_error());

$numbers=mysql_fetch_assoc($query);


if ($numbers['total_votes'] < 1) {
	$count = 0;
} else {
	$count=$numbers['total_votes']; //how many votes total
}
$current_rating=$numbers['total_value']; //total number of rating added together and stored
$tense=($count==1) ? "vote" : "votes"; //plural form votes/vote

// determine whether the user has voted, so we know how to draw the ul/li
$voted=mysql_num_rows(mysql_query("SELECT used_ips FROM tl_votesite WHERE used_ips LIKE '%".$ip."%' AND id='".$id."' ")); 

// now draw the rating bar
$rating_width = @number_format($current_rating/$count,2)*$rating_unitwidth;
$rating1 = @number_format($current_rating/$count,2);
$rating2 = @number_format($current_rating/$count,2);

if ($static == 'static') {

		$static_rater = array();
		$static_rater[] .= "\n".'<div class="ratingblock">';
		$static_rater[] .= '<div id="unit_long'.$id.'">';
		$static_rater[] .= '<ul id="unit_ul'.$id.'" class="unit-rating" style="width:'.$rating_unitwidth*$units.'px;">';
		$static_rater[] .= '<li class="current-rating" style="width:'.$rating_width.'px;">Currently '.$rating2.'/'.$units.'</li>';
		$static_rater[] .= '</ul>';
		$static_rater[] .= '<p class="static">Rating: <strong> '.$rating1.'</strong></p>';
		$static_rater[] .= '</div>';
		$static_rater[] .= '</div>'."\n\n";

		return join("\n", $static_rater);


} else {
	  
      $rater ='';
      $rater.='<div class="ratingblock">';

      $rater.='<div id="unit_long'.$id.'">';
      $rater.='  <ul id="unit_ul'.$id.'" class="unit-rating" style="width:'.$rating_unitwidth*$units.'px;">';
      $rater.='     <li class="current-rating" style="width:'.$rating_width.'px;">Currently '.$rating2.'/'.$units.'</li>';

      for ($ncount = 1; $ncount <= $units; $ncount++) { // loop from 1 to the number of units
           if(!$voted) { // if the user hasn't yet voted, draw the voting stars
              $rater.='<li><a href="'.$_SERVER['PHP_SELF'].'?d=1&amp;j='.$ncount.'&amp;q='.$id.'&amp;t='.$ip.'&amp;c='.$units.'" title="'.$ncount.' out of '.$units.'" class="r'.$ncount.'-unit rater" rel="nofollow">'.$ncount.'</a></li>';
       	 }
      }
$ncount=0; // resets the count

      $rater.='  </ul>';
      $rater.='  <p';
      if($voted){ $rater.=' class="voted"'; }
      $rater.='>Rating: <strong> '.$rating1.'</strong>';
      $rater.='  </p>';
      $rater.='</div>';
      $rater.='</div>';
      return $rater;
			}
		}

?>
